//
// Copyright 1999, 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// Version 2.
//

package com.perdues;

import java.io.*;


/**
  Copies from InputStream to OutputStream
  until EOF.  IOExceptions result in a RuntimeException
  thrown from "run".
  */
public class BytePump extends Thread {

  public BytePump(InputStream in, OutputStream out) {
    this.in = in;
    this.out = out;
  }

  /**
    Implementation of Thread.run.
    */
  public void run() {
    byte[] buf=new byte[1000];
    try {
      while (true) {
	int n=in.read(buf,0,buf.length);
	if (n<0) break;
	out.write(buf,0,n);
      }
    } catch (IOException ex) {
      throw new WrappedException(ex);
    }
  }

  private InputStream in;
  private OutputStream out;
}
