// Copyright 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// Version 2.

package com.perdues;

import java.util.*;
import java.io.*;


/**
  A RuntimeException to hold the state of any Throwable.
  This class allows a class to catch Exceptions or other
  Throwables that are not RuntimeExceptions and rethrow
  an exception that can display the stack trace and other
  information about the original problem.  The printStackTrack
  methods print a header followed by the stack trace for
  the underlying Throwable.
 */
public class WrappedException extends RuntimeException {

  public WrappedException(Throwable ex) {
    this.ex = ex;
  }

  public WrappedException(Throwable ex, String msg) {
    super(msg);
    this.ex = ex;
  }

  /**
    Returns the Throwable wrapped inside this WrappedException.
    */
  public Throwable getException() {
    return ex;
  }

  public void printStackTrace(PrintStream ps) {
    ps.println("WrappedException: "+getMessage());
    ex.printStackTrace(ps);
  }

  public void printStackTrace(PrintWriter pw) {
    pw.println("WrappedException: "+getMessage());
    ex.printStackTrace(pw);
  }

  public String toString() {
    return "WrappedException: "+getMessage()+"; "+ex.toString();
  }


  //// PRIVATE DATA ////

  private Throwable ex;

}

