// Copyright 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License.
// See http://www.gjt.org/doc/lgpl/license.html for details.

package com.perdues;

import java.util.*;


/**
   An object representing an XML tag.
 */
public class XMLTag extends Properties {

  //// Constructors ////

  public XMLTag(String tagname, boolean isEnd) {
    tagType = tagname;
    this.isEnd = isEnd;
  }


  //// Public Methods ////

  public String getType() {
    return tagType;
  }

  public boolean isEndTag() {
    return isEnd;
  }

  public void setEmpty(boolean is) {
    this.empty = is;
  }

  public boolean isEmpty() {
    return empty;
  }

  public XMLTag[] getElements() {
    if (elements==null) {
      elements = new XMLTag[ve.size()];
      ve.copyInto(elements);
    }
    return elements;
  }

  public void addElement(XMLTag tag) {
    elements = null;
    ve.addElement(tag);
  }


  //// Additional Properties-like method ////

  public String requiredProperty(String key) {
    String value = getProperty(key);
    if (value==null)
      throw new IllegalStateException(this+" needs required property "+key);
    return value;
  }


  //// Overridden from Object ////

  public String toString() {
    String end = isEndTag()?"/":"";
    String empty = isEmpty()?"/":"";
    XMLTag[] elts = getElements();
    String edisplay = isEmpty() ? "" : " "+PString.toString(getElements());
    return "<XMLTag "+end+getType()+" "+super.toString()+edisplay+empty+">";
  }


  //// Private Data ////

  private String tagType;
  private boolean isEnd;
  private boolean empty = false;
  private XMLTag[] elements = null;
  private Vector ve = new Vector();

}

