// Copyright 1999, 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License.
// See http://www.gjt.org/doc/lgpl/license.html for details.

package com.perdues.db;

import java.util.*;
import java.sql.*;
import com.perdues.XMLTag;


/**
  Each Schema object has an associated set of classes that
  perform various type-specific actions based on the extended types
  specified in the Schema.  These database type handler classes
  must implement the DBTypeHandler interface.
  */
public interface DBTypeHandler {

  /**
    Renders a form field given by name into an SQL literal, based
    on the extended type given by the ColumnInfo.  The type handler
    may also normalize the value that is actually in the form, for
    example stripping leading or trailing whitespace.  Returns
    the literal in a String.
    <P>
    This method takes a field name as well as a ColumnInfo so
    code that calls this can try different variations on the
    field name to allow the field name to encode the table name
    as well as the column name.  Must return
    null if the logical field is not present in the form.
    */
  public String renderForSQL(ColumnInfo col, Form form, String field);


  /**
     This method must render an HTML form element with input from
     the given form/field, suitable for working with data of the
     type of col and in the specified style, where style can currently
     be one of "entry" or "search".
  public String renderHTMLInput(ColumnInfo col, String style,
				Form form, String field);
   */


  /**
    Stores the value of the named field of the ResultSet
    into the given field of the form.
    */
  public void storeToForm(ColumnInfo col, ResultSet rs, String rsField,
			  Form form, String field) throws SQLException;


  /**
    Stores the value of the numbered field of the ResultSet
    into the given field of the form.
    */
  public void storeToForm(ColumnInfo col, ResultSet rs, int rsField,
			  Form form, String field) throws SQLException;


  /**
    Validates a Form field based on type information from the extended database
    schema.  For any validation problems, the method should add entries
    to <tt>errors</tt>, a Hashtable with String keys that are fully-qualified
    database field names and values that are String
    messages describing what is required for the form field.  A validator
    is required to check validity as fully as practical.  This validation
    is intended for data entry, to check as far as possible that each data
    item can be properly stored into the database.
    <P>
    TableInfo.validateRecord calls this for every column of the table so it can
    accommodate "virtual" form fields that don't map 1-to-1 onto columns.
    */
  public void validate(ColumnInfo col, Form form, Hashtable errors);

}
