// Copyright 2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import com.perdues.db.*;


/**
   Booleans are integers with value of 0 or 1.
   SQL accepts any nonzero value as true, but that
   is not valid in a form.
*/
public class BooleanTypeHandler extends IntegerTypeHandler {

  /**
     Construct a Boolean typeHandler.
    */
  public BooleanTypeHandler() {}


  //// IMPLEMENTATION OF DBTypeHandler ////

  /**
     Render as a 0 or 1, or null if not present.
  */
  public String renderForSQL(ColumnInfo col, Form form, String field) {
    String value = form.getValue(field);
    if (value==null)
      return null;
    if (Validate.okBoolean(value))
      throw new IllegalArgumentException("Boolean must be 0 or 1: "+value);
    return value;
  }


  /**
     
    */
  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String v = form.getValue(field);
    if ((v==null || v.length()==0) && col.isRequired()) {
      errs.put(col.getFullName(), " is required.");
    }
    if (Validate.okBoolean(v))
      throw new IllegalArgumentException("Boolean must be 0 or 1: "+v);
  }

}
