// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import java.util.Date;
import com.perdues.db.*;


public class DateTypeHandler implements DBTypeHandler {

  //// IMPLEMENTATION OF DBTypeHandler ////

  /**
     Permits a String value in standard SQL date format (YYYY-MM-DD),
     or a GSP virtual date field if no standard SQL date field.
  */
  public String renderForSQL(ColumnInfo col, Form form, String field) {
    String v = form.getValue(field);
    if (v!=null)
      return Query.sqlFormat(v);
    Date d = form.getDate(field);
    return d==null ? null : Query.sqlFormat(d);
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, String rsField,
			  Form form, String field) throws SQLException {
    form.setDate(field, rs.getDate(rsField));
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, int rsField,
			  Form form, String field) throws SQLException {
    form.setDate(field, rs.getDate(rsField));
  }


  /**
     Checks for a date, either a single field (e.g. hidden)
     or a specialized composite Date field.  Does not complain
     if no field is present.
  */
  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String name = col.getFullName();
    Date d = null;
    if (form.getValue(field)!=null) {
      try {
	java.sql.Date.valueOf(form.getValue(field));
      } catch (Exception ex) {
	errs.put(name, "date format not valid.");
      }
    } else if (form.getValue(field+"___month")!=null
	       && form.getDate(field)==null) {
      errs.put(name, "date format not valid.");
    } else if (col.isRequired()) {
      errs.put(name, "is required.");
    }
  }

}
