// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import java.sql.ResultSet;
import com.perdues.db.*;


/**
   Type handler for the Email address type.
   This calls Validate.emailIsValid() to validate email addresses.
*/
public class EmailTypeHandler extends StringTypeHandler implements DBTypeHandler {


  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String name = col.getFullName();
    String email = form.getValue(field, "");
    if (email.length()==0 && col.isRequired()) {
      errs.put(name, "is required.");
      return;
    }
    if (!Validate.okEmail(email)) {
      errs.put(name, " not a valid email");
    }
  }

}
