// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import java.sql.ResultSet;
import com.perdues.db.*;


/**
   Type handler for the ID type, integers starting with 1, used
   as unique IDs for rcords..  Checks that the field contains
   numerics only.
*/
public class IDTypeHandler extends NumericTypeHandler implements DBTypeHandler {

  //// IMPLEMENTATION OF DBTypeHandler ////

  public String renderForSQL(ColumnInfo col, Form form, String field) {
    // Assumes the data is valid!
    // Don't put quotes around an ID.
    return form.getValue(field);
  }


  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    super.validate(col, form, errs);
    String field = col.getName();
    String v = form.getValue(field);
    if ("0".equals(v))
      errs.put(col.getFullName(), " must be greater than zero.");
  }

}
