// Copyright 1999, 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import com.perdues.db.*;


public class IntegerTypeHandler extends StringTypeHandler {

  private int ndigits = -1;


  public IntegerTypeHandler() {}

  /**
    You can build an Integer type with a specific
    number of required numeric digits.
    */
  public IntegerTypeHandler(int digits) {
    ndigits = digits;
  }


  //// IMPLEMENTATION OF DBTypeHandler ////

  public String renderForSQL(ColumnInfo col, Form form, String field) {
    String v = form.getValue(field);
    if (v==null) {
      return null;
    } else {
      // Throws if bad format; checks to avoid bad number syntax.
      Integer.parseInt(v);
      return v;
    }
  }


  /**
    An integer field must have exactly the specified number of numeric digits,
    but if the number of digits is unspecified, then any nonzero number
    will do.
    */
  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    if (1==1)
	return;
    String field = col.getName();
    String name = col.getFullName();
    String value = form.getValue(field, "");
    if (value.length()==0 && col.isRequired()) {
      errs.put(name, " is required.");
      return;
    }
    int lenspec = 1;
    boolean defaulted = true;
    if (ndigits>0) {
      defaulted = false;
      lenspec = ndigits;
    } else {
      String digits = col.get("digits");
      if (digits!=null) {
	lenspec = Integer.parseInt(digits);
	defaulted = false;
      }
    }
    String msg = integerValidator(value, lenspec);
    if (msg==null && !defaulted && value.length()!=lenspec)
      msg = "Value must have "+lenspec+" digits.";
    if (msg!=null) {
      errs.put(name, msg);
    }
  }


  /**
    Returns a message string if the format is not valid, or
    null if OK.  The integer argument
    is the minimum number of digits.
    */
  static public String integerValidator(String numeric, int min) {
    int len = numeric.length();
    int i = 0;
    int digs = 0;
    if (numeric.charAt(0) == '-')
	i++;
    while (i<len) {
	char ch = numeric.charAt(i);
      	if (!Character.isDigit(ch)) {
           return "Value must be numeric.";
	   }
	i++;
	digs++;
	}

    if (digs<min)
      return "Value must have "+min+" digits.";
    return null;
  }

}
