// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import com.perdues.db.*;


/**
   Type handler for "Phone" == generic phone number type.  Format
   is any mixture of ASCII digits, spaces, parens, dashes, and the
   letter 'x' to indicate the beginning of an extension.
*/
public class PhoneTypeHandler extends StringTypeHandler {


  /**
     Validate a generic phone number as by Validate.okPhone.
  */
  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String name = col.getFullName();
    String phone = form.getValue(field, "");
    if (phone.length()==0 && col.isRequired()) {
      errs.put(name, "is required.");
      return;
    }
    if (!Validate.okPhone(phone)) {
      errs.put(name,
	       "Please enter a valid phone number, with optional extension.");
    }
  }

}
