// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import com.perdues.db.*;


/**
   On input, this handler accepts exactly 9 digits, with any
   number of blanks or '-' interspersed.  This does not normalize
   the Form entry itself, but renders only the digits into the
   SQL.  On retrieval, it adds '-' in the format of a personal
   Social Security number.
 */
public class SSNTypeHandler implements DBTypeHandler {


  //// IMPLEMENTATION OF DBTypeHandler ////

  public String renderForSQL(ColumnInfo col, Form form, String field) {
    String ssn = form.getValue(field, false);
    return "'"+toDBForm(ssn)+"'";
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, String rsField,
			  Form form, String field) throws SQLException {
    String ssn = rs.getString(rsField);
    setFormSSN(ssn, form, field);
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, int rsField,
			  Form form, String field) throws SQLException {
    String ssn = rs.getString(rsField);
    setFormSSN(ssn, form, field);
  }


  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String name = col.getFullName();
    String ssn = form.getValue(field, "");
    if (ssn.length()==0 && col.isRequired()) {
      errs.put(name, "is required.");
      return;
    }
    if (!Validate.okSSN(ssn)) {
      errs.put
	(name, "Please enter a 9-digit Social Security Number, e.g. 123-45-6789");
    }
  }



  //// UTILITY METHODS ////

  public static String toDBForm(String ssn) {
    StringBuffer buf = new StringBuffer();
    for (int i=0; i<ssn.length(); i++) {
      char ch = ssn.charAt(i);
      if (Character.isDigit(ch))
	buf.append(ch);
    }
    return buf.toString();
  }

  public static String toDisplayForm(String ssn) {
    StringBuffer buf = new StringBuffer();
    for (int i=0; i<ssn.length(); i++) {
      char ch = ssn.charAt(i);
      if (i==3 || i==5)
	buf.append('-');
      buf.append(ch);
    }
    return buf.toString();
  }



  //// PRIVATE ////

  private void setFormSSN(String ssn, Form form, String field) {
    // If gwe or if nulls allowed in DB.
    if (ssn==null) ssn = "";
    form.setValue(field, toDisplayForm(ssn));
  }
}
