// Copyright 1999-2001 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the Library GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.db.typeHandlers;

import java.util.*;
import java.sql.*;
import com.perdues.db.*;


/**
   This handler generally treats missing fields of the Form
   as empty Strings.  It does not treat them as database nulls.
   When validating, it also normalizes the Form value by trimming
   leading and trailing whitespace.  If the field is marked as
   "required" in the schema, an missing or empty normalized value
   is not valid.
*/
public class StringTypeHandler implements DBTypeHandler {


  //// IMPLEMENTATION OF DBTypeHandler ////

  /**
     Renders an SQL string literal for the field, or null if
     it is not present in the Form.
  */
  public String renderForSQL(ColumnInfo col, Form form, String field) {
    String v = form.getValue(field);
    if (v==null)
      return null;
    else
      return Query.sqlFormat(v.trim());
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, String rsField,
			  Form form, String field) throws SQLException {
    String val = rs.getString(rsField);
    form.setValue(field, val==null ? "" : val);
  }


  public void storeToForm(ColumnInfo col, ResultSet rs, int rsField,
			  Form form, String field) throws SQLException {
    String val = rs.getString(rsField);
    form.setValue(field, val==null ? "" : val);
  }


  public void validate(ColumnInfo col, Form form, Hashtable errs) {
    String field = col.getName();
    String v = form.getValue(field);
    if ((v==null || v.length()==0) && col.isRequired()) {
      errs.put(col.getFullName(), " is required.");
    }
  }

}
