// Copyright 1999, 2000 Crispin Perdue <cris@perdues.com>
// 
// This is free software, and comes with ABSOLUTELY NO WARRANTY.
// You may distribute it under the terms of the GNU Public License
// as specified in the LICENSE.txt file that comes with this distribution.

package com.perdues.web;

import java.util.*;
import java.io.*;
import java.net.*;
import java.text.*;


/**
   Standalone Java application to fetch a set of web pages and
   report their response codes.
   <P>
  */
public class URLCheck {
  
  /**
     The command line arguments should be a list of URLs.
     This accesses each URL in turn and reports the URL and
     the HTTP status code from the server for that URL on
     standard output.
  */
  public static void main(String[] args) {
    // Set debug mode on or off.
    debug = System.getProperty("debug")!=null;

    for (int i=0; i<args.length; i++) {
      HttpURLConnection conn = null;
      try {
	URL url = new URL(args[i]);
	String info = statusCheck(url);
	System.out.println(url.toString()+" "+info);
      } catch(IOException ex) {
	ex.printStackTrace(System.err);
	System.exit(1);
      }
    }
    // Exit for sure.
    System.exit(0);
  }

  public static boolean debug = false;


  //// PRIVATE METHODS ////

  /**
     Returns the status code and status message portion of the
     server's response to the given URL, using HTTP 1.0.
   */
  private static String statusCheck(URL url) throws IOException {
    String proto = url.getProtocol();
    String host = url.getHost();
    int port = url.getPort();
    if (port<0) port = 80;
    String path = url.getFile();

    Socket socket = null;
    try {
      socket = new Socket(host, port);

      OutputStream outs = socket.getOutputStream();
      PrintWriter w = new PrintWriter(new OutputStreamWriter(outs));
      w.println("GET "+path+" HTTP/1.0");
      w.println("");
      w.flush();

      InputStream ins = socket.getInputStream();
      BufferedReader r = new BufferedReader(new InputStreamReader(ins));
      String line = r.readLine();
      int pos = line.indexOf(" ");
      if (pos<0)
	throw new IllegalStateException
	  ("Bad server response: "+line);
      for (; pos<line.length() && line.charAt(pos)==' '; pos++) {}
      return line.substring(pos);

    } finally {
      if (socket!=null) {
	try {
	  socket.close();
	} catch(IOException ex) {}
      }
    }
  }

}
